package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CacheBehavior(behavior: scala.Option[BehaviorEnum] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CacheBehavior = {
    import CacheBehavior.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CacheBehavior.builder().optionallyWith(behavior.map(value => value.unwrap))(_.behavior).build()
  }
  def asReadOnly: CacheBehavior.ReadOnly = CacheBehavior.wrap(buildAwsValue())
}
object CacheBehavior {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CacheBehavior] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CacheBehavior = CacheBehavior(behaviorValue.map(value => value))
    def behaviorValue: scala.Option[BehaviorEnum]
    def behavior: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, BehaviorEnum] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("behavior", behaviorValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CacheBehavior) extends CacheBehavior.ReadOnly { override def behaviorValue: scala.Option[BehaviorEnum] = scala.Option(impl.behavior()).map(value => BehaviorEnum.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CacheBehavior): ReadOnly = new Wrapper(impl)
}