package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AccessKeyLastUsed(lastUsedDate: scala.Option[primitives.IsoDate] = None, region: scala.Option[String] = None, serviceName: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed = {
    import AccessKeyLastUsed.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed.builder().optionallyWith(lastUsedDate.map(value => value: java.time.Instant))(_.lastUsedDate).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(serviceName.map(value => value: java.lang.String))(_.serviceName).build()
  }
  def asReadOnly: AccessKeyLastUsed.ReadOnly = AccessKeyLastUsed.wrap(buildAwsValue())
}
object AccessKeyLastUsed {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AccessKeyLastUsed = AccessKeyLastUsed(lastUsedDateValue.map(value => value), regionValue.map(value => value), serviceNameValue.map(value => value))
    def lastUsedDateValue: scala.Option[primitives.IsoDate]
    def regionValue: scala.Option[String]
    def serviceNameValue: scala.Option[String]
    def lastUsedDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lastUsedDate", lastUsedDateValue)
    def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
    def serviceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("serviceName", serviceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed) extends AccessKeyLastUsed.ReadOnly {
    override def lastUsedDateValue: scala.Option[primitives.IsoDate] = scala.Option(impl.lastUsedDate()).map(value => value: primitives.IsoDate)
    override def regionValue: scala.Option[String] = scala.Option(impl.region()).map(value => value: String)
    override def serviceNameValue: scala.Option[String] = scala.Option(impl.serviceName()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AccessKeyLastUsed): ReadOnly = new Wrapper(impl)
}