package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateRelationalDatabaseRequest(relationalDatabaseName: primitives.ResourceName, masterUserPassword: scala.Option[primitives.SensitiveString] = None, rotateMasterUserPassword: scala.Option[Boolean] = None, preferredBackupWindow: scala.Option[String] = None, preferredMaintenanceWindow: scala.Option[String] = None, enableBackupRetention: scala.Option[Boolean] = None, disableBackupRetention: scala.Option[Boolean] = None, publiclyAccessible: scala.Option[Boolean] = None, applyImmediately: scala.Option[Boolean] = None, caCertificateIdentifier: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest = {
    import UpdateRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(rotateMasterUserPassword.map(value => value: java.lang.Boolean))(_.rotateMasterUserPassword).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(enableBackupRetention.map(value => value: java.lang.Boolean))(_.enableBackupRetention).optionallyWith(disableBackupRetention.map(value => value: java.lang.Boolean))(_.disableBackupRetention).optionallyWith(publiclyAccessible.map(value => value: java.lang.Boolean))(_.publiclyAccessible).optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(_.applyImmediately).optionallyWith(caCertificateIdentifier.map(value => value: java.lang.String))(_.caCertificateIdentifier).build()
  }
  def asReadOnly: UpdateRelationalDatabaseRequest.ReadOnly = UpdateRelationalDatabaseRequest.wrap(buildAwsValue())
}
object UpdateRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateRelationalDatabaseRequest = UpdateRelationalDatabaseRequest(relationalDatabaseNameValue, masterUserPasswordValue.map(value => value), rotateMasterUserPasswordValue.map(value => value), preferredBackupWindowValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), enableBackupRetentionValue.map(value => value), disableBackupRetentionValue.map(value => value), publiclyAccessibleValue.map(value => value), applyImmediatelyValue.map(value => value), caCertificateIdentifierValue.map(value => value))
    def relationalDatabaseNameValue: primitives.ResourceName
    def masterUserPasswordValue: scala.Option[primitives.SensitiveString]
    def rotateMasterUserPasswordValue: scala.Option[Boolean]
    def preferredBackupWindowValue: scala.Option[String]
    def preferredMaintenanceWindowValue: scala.Option[String]
    def enableBackupRetentionValue: scala.Option[Boolean]
    def disableBackupRetentionValue: scala.Option[Boolean]
    def publiclyAccessibleValue: scala.Option[Boolean]
    def applyImmediatelyValue: scala.Option[Boolean]
    def caCertificateIdentifierValue: scala.Option[String]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SensitiveString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
    def rotateMasterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("rotateMasterUserPassword", rotateMasterUserPasswordValue)
    def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
    def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
    def enableBackupRetention: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableBackupRetention", enableBackupRetentionValue)
    def disableBackupRetention: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("disableBackupRetention", disableBackupRetentionValue)
    def publiclyAccessible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
    def applyImmediately: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applyImmediately", applyImmediatelyValue)
    def caCertificateIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("caCertificateIdentifier", caCertificateIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest) extends UpdateRelationalDatabaseRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def masterUserPasswordValue: scala.Option[primitives.SensitiveString] = scala.Option(impl.masterUserPassword()).map(value => value: primitives.SensitiveString)
    override def rotateMasterUserPasswordValue: scala.Option[Boolean] = scala.Option(impl.rotateMasterUserPassword()).map(value => value: Boolean)
    override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
    override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
    override def enableBackupRetentionValue: scala.Option[Boolean] = scala.Option(impl.enableBackupRetention()).map(value => value: Boolean)
    override def disableBackupRetentionValue: scala.Option[Boolean] = scala.Option(impl.disableBackupRetention()).map(value => value: Boolean)
    override def publiclyAccessibleValue: scala.Option[Boolean] = scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override def applyImmediatelyValue: scala.Option[Boolean] = scala.Option(impl.applyImmediately()).map(value => value: Boolean)
    override def caCertificateIdentifierValue: scala.Option[String] = scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UpdateRelationalDatabaseRequest): ReadOnly = new Wrapper(impl)
}