package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateDistributionBundleRequest(distributionName: scala.Option[primitives.ResourceName] = None, bundleId: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest = {
    import UpdateDistributionBundleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest.builder().optionallyWith(distributionName.map(value => value: java.lang.String))(_.distributionName).optionallyWith(bundleId.map(value => value: java.lang.String))(_.bundleId).build()
  }
  def asReadOnly: UpdateDistributionBundleRequest.ReadOnly = UpdateDistributionBundleRequest.wrap(buildAwsValue())
}
object UpdateDistributionBundleRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateDistributionBundleRequest = UpdateDistributionBundleRequest(distributionNameValue.map(value => value), bundleIdValue.map(value => value))
    def distributionNameValue: scala.Option[primitives.ResourceName]
    def bundleIdValue: scala.Option[String]
    def distributionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("distributionName", distributionNameValue)
    def bundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bundleId", bundleIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest) extends UpdateDistributionBundleRequest.ReadOnly {
    override def distributionNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.distributionName()).map(value => value: primitives.ResourceName)
    override def bundleIdValue: scala.Option[String] = scala.Option(impl.bundleId()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UpdateDistributionBundleRequest): ReadOnly = new Wrapper(impl)
}