package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class StopInstanceRequest(instanceName: primitives.ResourceName, force: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.StopInstanceRequest = {
    import StopInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StopInstanceRequest.builder().instanceName(instanceName: java.lang.String).optionallyWith(force.map(value => value: java.lang.Boolean))(_.force).build()
  }
  def asReadOnly: StopInstanceRequest.ReadOnly = StopInstanceRequest.wrap(buildAwsValue())
}
object StopInstanceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.StopInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: StopInstanceRequest = StopInstanceRequest(instanceNameValue, forceValue.map(value => value))
    def instanceNameValue: primitives.ResourceName
    def forceValue: scala.Option[Boolean]
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
    def force: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("force", forceValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.StopInstanceRequest) extends StopInstanceRequest.ReadOnly {
    override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName
    override def forceValue: scala.Option[Boolean] = scala.Option(impl.force()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.StopInstanceRequest): ReadOnly = new Wrapper(impl)
}