package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class StartInstanceResponse(operations: scala.Option[Iterable[Operation]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.StartInstanceResponse = {
    import StartInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StartInstanceResponse.builder().optionallyWith(operations.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.operations).build()
  }
  def asReadOnly: StartInstanceResponse.ReadOnly = StartInstanceResponse.wrap(buildAwsValue())
}
object StartInstanceResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.StartInstanceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: StartInstanceResponse = StartInstanceResponse(operationsValue.map(value => value.map { item => 
      item.editable
    }))
    def operationsValue: scala.Option[List[Operation.ReadOnly]]
    def operations: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Operation.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("operations", operationsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.StartInstanceResponse) extends StartInstanceResponse.ReadOnly {
    override def operationsValue: scala.Option[List[Operation.ReadOnly]] = scala.Option(impl.operations()).map(value => value.asScala.map { item => 
      Operation.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.StartInstanceResponse): ReadOnly = new Wrapper(impl)
}