package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait LoadBalancerTlsCertificateDomainStatus { def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus }
object LoadBalancerTlsCertificateDomainStatus {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus): LoadBalancerTlsCertificateDomainStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus.PENDING_VALIDATION =>
      val r = PENDING_VALIDATION
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus.SUCCESS =>
      val r = SUCCESS
      r
  }
  case object unknownToSdkVersion extends LoadBalancerTlsCertificateDomainStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus.UNKNOWN_TO_SDK_VERSION }
  case object PENDING_VALIDATION extends LoadBalancerTlsCertificateDomainStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus.PENDING_VALIDATION }
  case object FAILED extends LoadBalancerTlsCertificateDomainStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus.FAILED }
  case object SUCCESS extends LoadBalancerTlsCertificateDomainStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus = software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainStatus.SUCCESS }
}