package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Instance(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, supportCode: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, tags: scala.Option[Iterable[Tag]] = None, blueprintId: scala.Option[primitives.NonEmptyString] = None, blueprintName: scala.Option[primitives.NonEmptyString] = None, bundleId: scala.Option[primitives.NonEmptyString] = None, addOns: scala.Option[Iterable[AddOn]] = None, isStaticIp: scala.Option[Boolean] = None, privateIpAddress: scala.Option[primitives.IpAddress] = None, publicIpAddress: scala.Option[primitives.IpAddress] = None, ipv6Addresses: scala.Option[Iterable[primitives.Ipv6Address]] = None, ipAddressType: scala.Option[IpAddressType] = None, hardware: scala.Option[InstanceHardware] = None, networking: scala.Option[InstanceNetworking] = None, state: scala.Option[InstanceState] = None, username: scala.Option[primitives.NonEmptyString] = None, sshKeyName: scala.Option[primitives.ResourceName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Instance.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(blueprintId.map(value => value: java.lang.String))(_.blueprintId).optionallyWith(blueprintName.map(value => value: java.lang.String))(_.blueprintName).optionallyWith(bundleId.map(value => value: java.lang.String))(_.bundleId).optionallyWith(addOns.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.addOns).optionallyWith(isStaticIp.map(value => value: java.lang.Boolean))(_.isStaticIp).optionallyWith(privateIpAddress.map(value => value: java.lang.String))(_.privateIpAddress).optionallyWith(publicIpAddress.map(value => value: java.lang.String))(_.publicIpAddress).optionallyWith(ipv6Addresses.map(value => value.map { item => 
      item: java.lang.String
    }.asJavaCollection))(_.ipv6Addresses).optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType).optionallyWith(hardware.map(value => value.buildAwsValue()))(_.hardware).optionallyWith(networking.map(value => value.buildAwsValue()))(_.networking).optionallyWith(state.map(value => value.buildAwsValue()))(_.state).optionallyWith(username.map(value => value: java.lang.String))(_.username).optionallyWith(sshKeyName.map(value => value: java.lang.String))(_.sshKeyName).build()
  }
  def asReadOnly: Instance.ReadOnly = Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.Instance] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Instance = Instance(nameValue.map(value => value), arnValue.map(value => value), supportCodeValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), blueprintIdValue.map(value => value), blueprintNameValue.map(value => value), bundleIdValue.map(value => value), addOnsValue.map(value => value.map { item => 
      item.editable
    }), isStaticIpValue.map(value => value), privateIpAddressValue.map(value => value), publicIpAddressValue.map(value => value), ipv6AddressesValue.map(value => value), ipAddressTypeValue.map(value => value), hardwareValue.map(value => value.editable), networkingValue.map(value => value.editable), stateValue.map(value => value.editable), usernameValue.map(value => value), sshKeyNameValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def supportCodeValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def blueprintIdValue: scala.Option[primitives.NonEmptyString]
    def blueprintNameValue: scala.Option[primitives.NonEmptyString]
    def bundleIdValue: scala.Option[primitives.NonEmptyString]
    def addOnsValue: scala.Option[List[AddOn.ReadOnly]]
    def isStaticIpValue: scala.Option[Boolean]
    def privateIpAddressValue: scala.Option[primitives.IpAddress]
    def publicIpAddressValue: scala.Option[primitives.IpAddress]
    def ipv6AddressesValue: scala.Option[List[primitives.Ipv6Address]]
    def ipAddressTypeValue: scala.Option[IpAddressType]
    def hardwareValue: scala.Option[InstanceHardware.ReadOnly]
    def networkingValue: scala.Option[InstanceNetworking.ReadOnly]
    def stateValue: scala.Option[InstanceState.ReadOnly]
    def usernameValue: scala.Option[primitives.NonEmptyString]
    def sshKeyNameValue: scala.Option[primitives.ResourceName]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def blueprintId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("blueprintId", blueprintIdValue)
    def blueprintName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("blueprintName", blueprintNameValue)
    def bundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def addOns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AddOn.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addOns", addOnsValue)
    def isStaticIp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isStaticIp", isStaticIpValue)
    def privateIpAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IpAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("privateIpAddress", privateIpAddressValue)
    def publicIpAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IpAddress] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publicIpAddress", publicIpAddressValue)
    def ipv6Addresses: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[primitives.Ipv6Address]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipv6Addresses", ipv6AddressesValue)
    def ipAddressType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IpAddressType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
    def hardware: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceHardware.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hardware", hardwareValue)
    def networking: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceNetworking.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("networking", networkingValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceState.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def username: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("username", usernameValue)
    def sshKeyName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sshKeyName", sshKeyNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.Instance) extends Instance.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def blueprintIdValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.blueprintId()).map(value => value: primitives.NonEmptyString)
    override def blueprintNameValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.blueprintName()).map(value => value: primitives.NonEmptyString)
    override def bundleIdValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.bundleId()).map(value => value: primitives.NonEmptyString)
    override def addOnsValue: scala.Option[List[AddOn.ReadOnly]] = scala.Option(impl.addOns()).map(value => value.asScala.map { item => 
      AddOn.wrap(item)
    }.toList)
    override def isStaticIpValue: scala.Option[Boolean] = scala.Option(impl.isStaticIp()).map(value => value: Boolean)
    override def privateIpAddressValue: scala.Option[primitives.IpAddress] = scala.Option(impl.privateIpAddress()).map(value => value: primitives.IpAddress)
    override def publicIpAddressValue: scala.Option[primitives.IpAddress] = scala.Option(impl.publicIpAddress()).map(value => value: primitives.IpAddress)
    override def ipv6AddressesValue: scala.Option[List[primitives.Ipv6Address]] = scala.Option(impl.ipv6Addresses()).map(value => value.asScala.map { item => 
      item: primitives.Ipv6Address
    }.toList)
    override def ipAddressTypeValue: scala.Option[IpAddressType] = scala.Option(impl.ipAddressType()).map(value => IpAddressType.wrap(value))
    override def hardwareValue: scala.Option[InstanceHardware.ReadOnly] = scala.Option(impl.hardware()).map(value => InstanceHardware.wrap(value))
    override def networkingValue: scala.Option[InstanceNetworking.ReadOnly] = scala.Option(impl.networking()).map(value => InstanceNetworking.wrap(value))
    override def stateValue: scala.Option[InstanceState.ReadOnly] = scala.Option(impl.state()).map(value => InstanceState.wrap(value))
    override def usernameValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.username()).map(value => value: primitives.NonEmptyString)
    override def sshKeyNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.sshKeyName()).map(value => value: primitives.ResourceName)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.Instance): ReadOnly = new Wrapper(impl)
}