package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseBundlesResponse(bundles: scala.Option[Iterable[RelationalDatabaseBundle]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse = {
    import GetRelationalDatabaseBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse.builder().optionallyWith(bundles.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.bundles).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetRelationalDatabaseBundlesResponse.ReadOnly = GetRelationalDatabaseBundlesResponse.wrap(buildAwsValue())
}
object GetRelationalDatabaseBundlesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseBundlesResponse = GetRelationalDatabaseBundlesResponse(bundlesValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def bundlesValue: scala.Option[List[RelationalDatabaseBundle.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def bundles: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RelationalDatabaseBundle.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bundles", bundlesValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse) extends GetRelationalDatabaseBundlesResponse.ReadOnly {
    override def bundlesValue: scala.Option[List[RelationalDatabaseBundle.ReadOnly]] = scala.Option(impl.bundles()).map(value => value.asScala.map { item => 
      RelationalDatabaseBundle.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse): ReadOnly = new Wrapper(impl)
}