package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetLoadBalancerTlsCertificatesRequest(loadBalancerName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest = {
    import GetLoadBalancerTlsCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest.builder().loadBalancerName(loadBalancerName: java.lang.String).build()
  }
  def asReadOnly: GetLoadBalancerTlsCertificatesRequest.ReadOnly = GetLoadBalancerTlsCertificatesRequest.wrap(buildAwsValue())
}
object GetLoadBalancerTlsCertificatesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetLoadBalancerTlsCertificatesRequest = GetLoadBalancerTlsCertificatesRequest(loadBalancerNameValue)
    def loadBalancerNameValue: primitives.ResourceName
    def loadBalancerName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(loadBalancerNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest) extends GetLoadBalancerTlsCertificatesRequest.ReadOnly { override def loadBalancerNameValue: primitives.ResourceName = impl.loadBalancerName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerTlsCertificatesRequest): ReadOnly = new Wrapper(impl)
}