package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetDistributionsResponse(distributions: scala.Option[Iterable[LightsailDistribution]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse = {
    import GetDistributionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse.builder().optionallyWith(distributions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.distributions).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetDistributionsResponse.ReadOnly = GetDistributionsResponse.wrap(buildAwsValue())
}
object GetDistributionsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetDistributionsResponse = GetDistributionsResponse(distributionsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def distributionsValue: scala.Option[List[LightsailDistribution.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def distributions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[LightsailDistribution.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("distributions", distributionsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse) extends GetDistributionsResponse.ReadOnly {
    override def distributionsValue: scala.Option[List[LightsailDistribution.ReadOnly]] = scala.Option(impl.distributions()).map(value => value.asScala.map { item => 
      LightsailDistribution.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetDistributionsResponse): ReadOnly = new Wrapper(impl)
}