package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerServiceDeploymentsRequest(serviceName: primitives.ContainerServiceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest = {
    import GetContainerServiceDeploymentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest.builder().serviceName(serviceName: java.lang.String).build()
  }
  def asReadOnly: GetContainerServiceDeploymentsRequest.ReadOnly = GetContainerServiceDeploymentsRequest.wrap(buildAwsValue())
}
object GetContainerServiceDeploymentsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerServiceDeploymentsRequest = GetContainerServiceDeploymentsRequest(serviceNameValue)
    def serviceNameValue: primitives.ContainerServiceName
    def serviceName: ZIO[Any, Nothing, primitives.ContainerServiceName] = ZIO.succeed(serviceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest) extends GetContainerServiceDeploymentsRequest.ReadOnly { override def serviceNameValue: primitives.ContainerServiceName = impl.serviceName(): primitives.ContainerServiceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsRequest): ReadOnly = new Wrapper(impl)
}