package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerLogRequest(serviceName: primitives.ContainerServiceName, containerName: String, startTime: scala.Option[primitives.IsoDate] = None, endTime: scala.Option[primitives.IsoDate] = None, filterPattern: scala.Option[String] = None, pageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest = {
    import GetContainerLogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest.builder().serviceName(serviceName: java.lang.String).containerName(containerName: java.lang.String).optionallyWith(startTime.map(value => value: java.time.Instant))(_.startTime).optionallyWith(endTime.map(value => value: java.time.Instant))(_.endTime).optionallyWith(filterPattern.map(value => value: java.lang.String))(_.filterPattern).optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).build()
  }
  def asReadOnly: GetContainerLogRequest.ReadOnly = GetContainerLogRequest.wrap(buildAwsValue())
}
object GetContainerLogRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerLogRequest = GetContainerLogRequest(serviceNameValue, containerNameValue, startTimeValue.map(value => value), endTimeValue.map(value => value), filterPatternValue.map(value => value), pageTokenValue.map(value => value))
    def serviceNameValue: primitives.ContainerServiceName
    def containerNameValue: String
    def startTimeValue: scala.Option[primitives.IsoDate]
    def endTimeValue: scala.Option[primitives.IsoDate]
    def filterPatternValue: scala.Option[String]
    def pageTokenValue: scala.Option[String]
    def serviceName: ZIO[Any, Nothing, primitives.ContainerServiceName] = ZIO.succeed(serviceNameValue)
    def containerName: ZIO[Any, Nothing, String] = ZIO.succeed(containerNameValue)
    def startTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("startTime", startTimeValue)
    def endTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endTime", endTimeValue)
    def filterPattern: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filterPattern", filterPatternValue)
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest) extends GetContainerLogRequest.ReadOnly {
    override def serviceNameValue: primitives.ContainerServiceName = impl.serviceName(): primitives.ContainerServiceName
    override def containerNameValue: String = impl.containerName(): String
    override def startTimeValue: scala.Option[primitives.IsoDate] = scala.Option(impl.startTime()).map(value => value: primitives.IsoDate)
    override def endTimeValue: scala.Option[primitives.IsoDate] = scala.Option(impl.endTime()).map(value => value: primitives.IsoDate)
    override def filterPatternValue: scala.Option[String] = scala.Option(impl.filterPattern()).map(value => value: String)
    override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest): ReadOnly = new Wrapper(impl)
}