package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContactMethodsRequest(protocols: scala.Option[Iterable[ContactProtocol]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest = {
    import GetContactMethodsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest.builder().optionallyWith(protocols.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.protocolsWithStrings).build()
  }
  def asReadOnly: GetContactMethodsRequest.ReadOnly = GetContactMethodsRequest.wrap(buildAwsValue())
}
object GetContactMethodsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContactMethodsRequest = GetContactMethodsRequest(protocolsValue.map(value => value))
    def protocolsValue: scala.Option[List[ContactProtocol]]
    def protocols: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ContactProtocol]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("protocols", protocolsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest) extends GetContactMethodsRequest.ReadOnly {
    override def protocolsValue: scala.Option[List[ContactProtocol]] = scala.Option(impl.protocols()).map(value => value.asScala.map { item => 
      ContactProtocol.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContactMethodsRequest): ReadOnly = new Wrapper(impl)
}