package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetBucketAccessKeysResponse(accessKeys: scala.Option[Iterable[AccessKey]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse = {
    import GetBucketAccessKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse.builder().optionallyWith(accessKeys.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.accessKeys).build()
  }
  def asReadOnly: GetBucketAccessKeysResponse.ReadOnly = GetBucketAccessKeysResponse.wrap(buildAwsValue())
}
object GetBucketAccessKeysResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetBucketAccessKeysResponse = GetBucketAccessKeysResponse(accessKeysValue.map(value => value.map { item => 
      item.editable
    }))
    def accessKeysValue: scala.Option[List[AccessKey.ReadOnly]]
    def accessKeys: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AccessKey.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accessKeys", accessKeysValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse) extends GetBucketAccessKeysResponse.ReadOnly {
    override def accessKeysValue: scala.Option[List[AccessKey.ReadOnly]] = scala.Option(impl.accessKeys()).map(value => value.asScala.map { item => 
      AccessKey.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse): ReadOnly = new Wrapper(impl)
}