package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetBucketAccessKeysRequest(bucketName: primitives.BucketName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest = {
    import GetBucketAccessKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest.builder().bucketName(bucketName: java.lang.String).build()
  }
  def asReadOnly: GetBucketAccessKeysRequest.ReadOnly = GetBucketAccessKeysRequest.wrap(buildAwsValue())
}
object GetBucketAccessKeysRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetBucketAccessKeysRequest = GetBucketAccessKeysRequest(bucketNameValue)
    def bucketNameValue: primitives.BucketName
    def bucketName: ZIO[Any, Nothing, primitives.BucketName] = ZIO.succeed(bucketNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest) extends GetBucketAccessKeysRequest.ReadOnly { override def bucketNameValue: primitives.BucketName = impl.bucketName(): primitives.BucketName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysRequest): ReadOnly = new Wrapper(impl)
}