package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ExportSnapshotRequest(sourceSnapshotName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest = {
    import ExportSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest.builder().sourceSnapshotName(sourceSnapshotName: java.lang.String).build()
  }
  def asReadOnly: ExportSnapshotRequest.ReadOnly = ExportSnapshotRequest.wrap(buildAwsValue())
}
object ExportSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ExportSnapshotRequest = ExportSnapshotRequest(sourceSnapshotNameValue)
    def sourceSnapshotNameValue: primitives.ResourceName
    def sourceSnapshotName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(sourceSnapshotNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest) extends ExportSnapshotRequest.ReadOnly { override def sourceSnapshotNameValue: primitives.ResourceName = impl.sourceSnapshotName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRequest): ReadOnly = new Wrapper(impl)
}