package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteContainerImageRequest(serviceName: primitives.ContainerServiceName, image: String) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest = {
    import DeleteContainerImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest.builder().serviceName(serviceName: java.lang.String).image(image: java.lang.String).build()
  }
  def asReadOnly: DeleteContainerImageRequest.ReadOnly = DeleteContainerImageRequest.wrap(buildAwsValue())
}
object DeleteContainerImageRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteContainerImageRequest = DeleteContainerImageRequest(serviceNameValue, imageValue)
    def serviceNameValue: primitives.ContainerServiceName
    def imageValue: String
    def serviceName: ZIO[Any, Nothing, primitives.ContainerServiceName] = ZIO.succeed(serviceNameValue)
    def image: ZIO[Any, Nothing, String] = ZIO.succeed(imageValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest) extends DeleteContainerImageRequest.ReadOnly {
    override def serviceNameValue: primitives.ContainerServiceName = impl.serviceName(): primitives.ContainerServiceName
    override def imageValue: String = impl.image(): String
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest): ReadOnly = new Wrapper(impl)
}