package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteCertificateRequest(certificateName: primitives.CertificateName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest = {
    import DeleteCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest.builder().certificateName(certificateName: java.lang.String).build()
  }
  def asReadOnly: DeleteCertificateRequest.ReadOnly = DeleteCertificateRequest.wrap(buildAwsValue())
}
object DeleteCertificateRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteCertificateRequest = DeleteCertificateRequest(certificateNameValue)
    def certificateNameValue: primitives.CertificateName
    def certificateName: ZIO[Any, Nothing, primitives.CertificateName] = ZIO.succeed(certificateNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest) extends DeleteCertificateRequest.ReadOnly { override def certificateNameValue: primitives.CertificateName = impl.certificateName(): primitives.CertificateName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest): ReadOnly = new Wrapper(impl)
}