package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateRelationalDatabaseSnapshotRequest(relationalDatabaseName: primitives.ResourceName, relationalDatabaseSnapshotName: primitives.ResourceName, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest = {
    import CreateRelationalDatabaseSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).relationalDatabaseSnapshotName(relationalDatabaseSnapshotName: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateRelationalDatabaseSnapshotRequest.ReadOnly = CreateRelationalDatabaseSnapshotRequest.wrap(buildAwsValue())
}
object CreateRelationalDatabaseSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateRelationalDatabaseSnapshotRequest = CreateRelationalDatabaseSnapshotRequest(relationalDatabaseNameValue, relationalDatabaseSnapshotNameValue, tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def relationalDatabaseNameValue: primitives.ResourceName
    def relationalDatabaseSnapshotNameValue: primitives.ResourceName
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def relationalDatabaseSnapshotName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseSnapshotNameValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest) extends CreateRelationalDatabaseSnapshotRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def relationalDatabaseSnapshotNameValue: primitives.ResourceName = impl.relationalDatabaseSnapshotName(): primitives.ResourceName
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateRelationalDatabaseSnapshotRequest): ReadOnly = new Wrapper(impl)
}