package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateContainerServiceResponse(containerService: scala.Option[ContainerService] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse = {
    import CreateContainerServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse.builder().optionallyWith(containerService.map(value => value.buildAwsValue()))(_.containerService).build()
  }
  def asReadOnly: CreateContainerServiceResponse.ReadOnly = CreateContainerServiceResponse.wrap(buildAwsValue())
}
object CreateContainerServiceResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateContainerServiceResponse = CreateContainerServiceResponse(containerServiceValue.map(value => value.editable))
    def containerServiceValue: scala.Option[ContainerService.ReadOnly]
    def containerService: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerService.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containerService", containerServiceValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse) extends CreateContainerServiceResponse.ReadOnly { override def containerServiceValue: scala.Option[ContainerService.ReadOnly] = scala.Option(impl.containerService()).map(value => ContainerService.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse): ReadOnly = new Wrapper(impl)
}