package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateContainerServiceDeploymentRequest(serviceName: primitives.ContainerServiceName, containers: scala.Option[Map[primitives.ContainerName, Container]] = None, publicEndpoint: scala.Option[EndpointRequest] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest = {
    import CreateContainerServiceDeploymentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest.builder().serviceName(serviceName: java.lang.String).optionallyWith(containers.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.buildAwsValue()
    }).asJava))(_.containers).optionallyWith(publicEndpoint.map(value => value.buildAwsValue()))(_.publicEndpoint).build()
  }
  def asReadOnly: CreateContainerServiceDeploymentRequest.ReadOnly = CreateContainerServiceDeploymentRequest.wrap(buildAwsValue())
}
object CreateContainerServiceDeploymentRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateContainerServiceDeploymentRequest = CreateContainerServiceDeploymentRequest(serviceNameValue, containersValue.map(value => value.map({
      case (key, value) =>
        key -> value.editable
    })), publicEndpointValue.map(value => value.editable))
    def serviceNameValue: primitives.ContainerServiceName
    def containersValue: scala.Option[Map[primitives.ContainerName, Container.ReadOnly]]
    def publicEndpointValue: scala.Option[EndpointRequest.ReadOnly]
    def serviceName: ZIO[Any, Nothing, primitives.ContainerServiceName] = ZIO.succeed(serviceNameValue)
    def containers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.ContainerName, Container.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containers", containersValue)
    def publicEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EndpointRequest.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publicEndpoint", publicEndpointValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest) extends CreateContainerServiceDeploymentRequest.ReadOnly {
    override def serviceNameValue: primitives.ContainerServiceName = impl.serviceName(): primitives.ContainerServiceName
    override def containersValue: scala.Option[Map[primitives.ContainerName, Container.ReadOnly]] = scala.Option(impl.containers()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.ContainerName) -> Container.wrap(value)
    }).toMap)
    override def publicEndpointValue: scala.Option[EndpointRequest.ReadOnly] = scala.Option(impl.publicEndpoint()).map(value => EndpointRequest.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceDeploymentRequest): ReadOnly = new Wrapper(impl)
}