package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateBucketRequest(bucketName: primitives.BucketName, bundleId: primitives.NonEmptyString, tags: scala.Option[Iterable[Tag]] = None, enableObjectVersioning: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateBucketRequest = {
    import CreateBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateBucketRequest.builder().bucketName(bucketName: java.lang.String).bundleId(bundleId: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(enableObjectVersioning.map(value => value: java.lang.Boolean))(_.enableObjectVersioning).build()
  }
  def asReadOnly: CreateBucketRequest.ReadOnly = CreateBucketRequest.wrap(buildAwsValue())
}
object CreateBucketRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateBucketRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateBucketRequest = CreateBucketRequest(bucketNameValue, bundleIdValue, tagsValue.map(value => value.map { item => 
      item.editable
    }), enableObjectVersioningValue.map(value => value))
    def bucketNameValue: primitives.BucketName
    def bundleIdValue: primitives.NonEmptyString
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def enableObjectVersioningValue: scala.Option[Boolean]
    def bucketName: ZIO[Any, Nothing, primitives.BucketName] = ZIO.succeed(bucketNameValue)
    def bundleId: ZIO[Any, Nothing, primitives.NonEmptyString] = ZIO.succeed(bundleIdValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def enableObjectVersioning: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableObjectVersioning", enableObjectVersioningValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateBucketRequest) extends CreateBucketRequest.ReadOnly {
    override def bucketNameValue: primitives.BucketName = impl.bucketName(): primitives.BucketName
    override def bundleIdValue: primitives.NonEmptyString = impl.bundleId(): primitives.NonEmptyString
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def enableObjectVersioningValue: scala.Option[Boolean] = scala.Option(impl.enableObjectVersioning()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateBucketRequest): ReadOnly = new Wrapper(impl)
}