package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ContainerServiceStateDetail(code: scala.Option[ContainerServiceStateDetailCode] = None, message: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail = {
    import ContainerServiceStateDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail.builder().optionallyWith(code.map(value => value.unwrap))(_.code).optionallyWith(message.map(value => value: java.lang.String))(_.message).build()
  }
  def asReadOnly: ContainerServiceStateDetail.ReadOnly = ContainerServiceStateDetail.wrap(buildAwsValue())
}
object ContainerServiceStateDetail {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ContainerServiceStateDetail = ContainerServiceStateDetail(codeValue.map(value => value), messageValue.map(value => value))
    def codeValue: scala.Option[ContainerServiceStateDetailCode]
    def messageValue: scala.Option[String]
    def code: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceStateDetailCode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("code", codeValue)
    def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail) extends ContainerServiceStateDetail.ReadOnly {
    override def codeValue: scala.Option[ContainerServiceStateDetailCode] = scala.Option(impl.code()).map(value => ContainerServiceStateDetailCode.wrap(value))
    override def messageValue: scala.Option[String] = scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceStateDetail): ReadOnly = new Wrapper(impl)
}