package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ContainerServiceEndpoint(containerName: scala.Option[String] = None, containerPort: scala.Option[primitives.Integer] = None, healthCheck: scala.Option[ContainerServiceHealthCheckConfig] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint = {
    import ContainerServiceEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint.builder().optionallyWith(containerName.map(value => value: java.lang.String))(_.containerName).optionallyWith(containerPort.map(value => value: java.lang.Integer))(_.containerPort).optionallyWith(healthCheck.map(value => value.buildAwsValue()))(_.healthCheck).build()
  }
  def asReadOnly: ContainerServiceEndpoint.ReadOnly = ContainerServiceEndpoint.wrap(buildAwsValue())
}
object ContainerServiceEndpoint {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ContainerServiceEndpoint = ContainerServiceEndpoint(containerNameValue.map(value => value), containerPortValue.map(value => value), healthCheckValue.map(value => value.editable))
    def containerNameValue: scala.Option[String]
    def containerPortValue: scala.Option[primitives.Integer]
    def healthCheckValue: scala.Option[ContainerServiceHealthCheckConfig.ReadOnly]
    def containerName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containerName", containerNameValue)
    def containerPort: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containerPort", containerPortValue)
    def healthCheck: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerServiceHealthCheckConfig.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("healthCheck", healthCheckValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint) extends ContainerServiceEndpoint.ReadOnly {
    override def containerNameValue: scala.Option[String] = scala.Option(impl.containerName()).map(value => value: String)
    override def containerPortValue: scala.Option[primitives.Integer] = scala.Option(impl.containerPort()).map(value => value: primitives.Integer)
    override def healthCheckValue: scala.Option[ContainerServiceHealthCheckConfig.ReadOnly] = scala.Option(impl.healthCheck()).map(value => ContainerServiceHealthCheckConfig.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ContainerServiceEndpoint): ReadOnly = new Wrapper(impl)
}