package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AttachStaticIpRequest(staticIpName: primitives.ResourceName, instanceName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest = {
    import AttachStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest.builder().staticIpName(staticIpName: java.lang.String).instanceName(instanceName: java.lang.String).build()
  }
  def asReadOnly: AttachStaticIpRequest.ReadOnly = AttachStaticIpRequest.wrap(buildAwsValue())
}
object AttachStaticIpRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AttachStaticIpRequest = AttachStaticIpRequest(staticIpNameValue, instanceNameValue)
    def staticIpNameValue: primitives.ResourceName
    def instanceNameValue: primitives.ResourceName
    def staticIpName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(staticIpNameValue)
    def instanceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest) extends AttachStaticIpRequest.ReadOnly {
    override def staticIpNameValue: primitives.ResourceName = impl.staticIpName(): primitives.ResourceName
    override def instanceNameValue: primitives.ResourceName = impl.instanceName(): primitives.ResourceName
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AttachStaticIpRequest): ReadOnly = new Wrapper(impl)
}