package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateContainerServiceResponse(containerService: scala.Option[ContainerService] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse = {
    import UpdateContainerServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse.builder().optionallyWith(containerService.map(value => value.buildAwsValue()))(_.containerService).build()
  }
  def asReadOnly: UpdateContainerServiceResponse.ReadOnly = UpdateContainerServiceResponse.wrap(buildAwsValue())
}
object UpdateContainerServiceResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateContainerServiceResponse = UpdateContainerServiceResponse(containerServiceValue.map(value => value.editable))
    def containerServiceValue: scala.Option[ContainerService.ReadOnly]
    def containerService: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ContainerService.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("containerService", containerServiceValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse) extends UpdateContainerServiceResponse.ReadOnly { override def containerServiceValue: scala.Option[ContainerService.ReadOnly] = scala.Option(impl.containerService()).map(value => ContainerService.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.UpdateContainerServiceResponse): ReadOnly = new Wrapper(impl)
}