package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RelationalDatabaseBundle(bundleId: scala.Option[String] = None, name: scala.Option[String] = None, price: scala.Option[Float] = None, ramSizeInGb: scala.Option[Float] = None, diskSizeInGb: scala.Option[primitives.Integer] = None, transferPerMonthInGb: scala.Option[primitives.Integer] = None, cpuCount: scala.Option[primitives.Integer] = None, isEncrypted: scala.Option[Boolean] = None, isActive: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle = {
    import RelationalDatabaseBundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle.builder().optionallyWith(bundleId.map(value => value: java.lang.String))(_.bundleId).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(price.map(value => value: java.lang.Float))(_.price).optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(_.ramSizeInGb).optionallyWith(diskSizeInGb.map(value => value: java.lang.Integer))(_.diskSizeInGb).optionallyWith(transferPerMonthInGb.map(value => value: java.lang.Integer))(_.transferPerMonthInGb).optionallyWith(cpuCount.map(value => value: java.lang.Integer))(_.cpuCount).optionallyWith(isEncrypted.map(value => value: java.lang.Boolean))(_.isEncrypted).optionallyWith(isActive.map(value => value: java.lang.Boolean))(_.isActive).build()
  }
  def asReadOnly: RelationalDatabaseBundle.ReadOnly = RelationalDatabaseBundle.wrap(buildAwsValue())
}
object RelationalDatabaseBundle {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RelationalDatabaseBundle = RelationalDatabaseBundle(bundleIdValue.map(value => value), nameValue.map(value => value), priceValue.map(value => value), ramSizeInGbValue.map(value => value), diskSizeInGbValue.map(value => value), transferPerMonthInGbValue.map(value => value), cpuCountValue.map(value => value), isEncryptedValue.map(value => value), isActiveValue.map(value => value))
    def bundleIdValue: scala.Option[String]
    def nameValue: scala.Option[String]
    def priceValue: scala.Option[Float]
    def ramSizeInGbValue: scala.Option[Float]
    def diskSizeInGbValue: scala.Option[primitives.Integer]
    def transferPerMonthInGbValue: scala.Option[primitives.Integer]
    def cpuCountValue: scala.Option[primitives.Integer]
    def isEncryptedValue: scala.Option[Boolean]
    def isActiveValue: scala.Option[Boolean]
    def bundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def price: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Float] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("price", priceValue)
    def ramSizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Float] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGbValue)
    def diskSizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskSizeInGb", diskSizeInGbValue)
    def transferPerMonthInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("transferPerMonthInGb", transferPerMonthInGbValue)
    def cpuCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cpuCount", cpuCountValue)
    def isEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isEncrypted", isEncryptedValue)
    def isActive: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isActive", isActiveValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle) extends RelationalDatabaseBundle.ReadOnly {
    override def bundleIdValue: scala.Option[String] = scala.Option(impl.bundleId()).map(value => value: String)
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
    override def priceValue: scala.Option[Float] = scala.Option(impl.price()).map(value => value: Float)
    override def ramSizeInGbValue: scala.Option[Float] = scala.Option(impl.ramSizeInGb()).map(value => value: Float)
    override def diskSizeInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.diskSizeInGb()).map(value => value: primitives.Integer)
    override def transferPerMonthInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.transferPerMonthInGb()).map(value => value: primitives.Integer)
    override def cpuCountValue: scala.Option[primitives.Integer] = scala.Option(impl.cpuCount()).map(value => value: primitives.Integer)
    override def isEncryptedValue: scala.Option[Boolean] = scala.Option(impl.isEncrypted()).map(value => value: Boolean)
    override def isActiveValue: scala.Option[Boolean] = scala.Option(impl.isActive()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle): ReadOnly = new Wrapper(impl)
}