package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RelationalDatabase(name: scala.Option[primitives.ResourceName] = None, arn: scala.Option[primitives.NonEmptyString] = None, supportCode: scala.Option[String] = None, createdAt: scala.Option[primitives.IsoDate] = None, location: scala.Option[ResourceLocation] = None, resourceType: scala.Option[ResourceType] = None, tags: scala.Option[Iterable[Tag]] = None, relationalDatabaseBlueprintId: scala.Option[primitives.NonEmptyString] = None, relationalDatabaseBundleId: scala.Option[primitives.NonEmptyString] = None, masterDatabaseName: scala.Option[String] = None, hardware: scala.Option[RelationalDatabaseHardware] = None, state: scala.Option[primitives.NonEmptyString] = None, secondaryAvailabilityZone: scala.Option[String] = None, backupRetentionEnabled: scala.Option[Boolean] = None, pendingModifiedValues: scala.Option[PendingModifiedRelationalDatabaseValues] = None, engine: scala.Option[primitives.NonEmptyString] = None, engineVersion: scala.Option[primitives.NonEmptyString] = None, latestRestorableTime: scala.Option[primitives.IsoDate] = None, masterUsername: scala.Option[primitives.NonEmptyString] = None, parameterApplyStatus: scala.Option[primitives.NonEmptyString] = None, preferredBackupWindow: scala.Option[primitives.NonEmptyString] = None, preferredMaintenanceWindow: scala.Option[primitives.NonEmptyString] = None, publiclyAccessible: scala.Option[Boolean] = None, masterEndpoint: scala.Option[RelationalDatabaseEndpoint] = None, pendingMaintenanceActions: scala.Option[Iterable[PendingMaintenanceAction]] = None, caCertificateIdentifier: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.RelationalDatabase = {
    import RelationalDatabase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabase.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(supportCode.map(value => value: java.lang.String))(_.supportCode).optionallyWith(createdAt.map(value => value: java.time.Instant))(_.createdAt).optionallyWith(location.map(value => value.buildAwsValue()))(_.location).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(relationalDatabaseBlueprintId.map(value => value: java.lang.String))(_.relationalDatabaseBlueprintId).optionallyWith(relationalDatabaseBundleId.map(value => value: java.lang.String))(_.relationalDatabaseBundleId).optionallyWith(masterDatabaseName.map(value => value: java.lang.String))(_.masterDatabaseName).optionallyWith(hardware.map(value => value.buildAwsValue()))(_.hardware).optionallyWith(state.map(value => value: java.lang.String))(_.state).optionallyWith(secondaryAvailabilityZone.map(value => value: java.lang.String))(_.secondaryAvailabilityZone).optionallyWith(backupRetentionEnabled.map(value => value: java.lang.Boolean))(_.backupRetentionEnabled).optionallyWith(pendingModifiedValues.map(value => value.buildAwsValue()))(_.pendingModifiedValues).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(latestRestorableTime.map(value => value: java.time.Instant))(_.latestRestorableTime).optionallyWith(masterUsername.map(value => value: java.lang.String))(_.masterUsername).optionallyWith(parameterApplyStatus.map(value => value: java.lang.String))(_.parameterApplyStatus).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(publiclyAccessible.map(value => value: java.lang.Boolean))(_.publiclyAccessible).optionallyWith(masterEndpoint.map(value => value.buildAwsValue()))(_.masterEndpoint).optionallyWith(pendingMaintenanceActions.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.pendingMaintenanceActions).optionallyWith(caCertificateIdentifier.map(value => value: java.lang.String))(_.caCertificateIdentifier).build()
  }
  def asReadOnly: RelationalDatabase.ReadOnly = RelationalDatabase.wrap(buildAwsValue())
}
object RelationalDatabase {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.RelationalDatabase] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RelationalDatabase = RelationalDatabase(nameValue.map(value => value), arnValue.map(value => value), supportCodeValue.map(value => value), createdAtValue.map(value => value), locationValue.map(value => value.editable), resourceTypeValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), relationalDatabaseBlueprintIdValue.map(value => value), relationalDatabaseBundleIdValue.map(value => value), masterDatabaseNameValue.map(value => value), hardwareValue.map(value => value.editable), stateValue.map(value => value), secondaryAvailabilityZoneValue.map(value => value), backupRetentionEnabledValue.map(value => value), pendingModifiedValuesValue.map(value => value.editable), engineValue.map(value => value), engineVersionValue.map(value => value), latestRestorableTimeValue.map(value => value), masterUsernameValue.map(value => value), parameterApplyStatusValue.map(value => value), preferredBackupWindowValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), publiclyAccessibleValue.map(value => value), masterEndpointValue.map(value => value.editable), pendingMaintenanceActionsValue.map(value => value.map { item => 
      item.editable
    }), caCertificateIdentifierValue.map(value => value))
    def nameValue: scala.Option[primitives.ResourceName]
    def arnValue: scala.Option[primitives.NonEmptyString]
    def supportCodeValue: scala.Option[String]
    def createdAtValue: scala.Option[primitives.IsoDate]
    def locationValue: scala.Option[ResourceLocation.ReadOnly]
    def resourceTypeValue: scala.Option[ResourceType]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def relationalDatabaseBlueprintIdValue: scala.Option[primitives.NonEmptyString]
    def relationalDatabaseBundleIdValue: scala.Option[primitives.NonEmptyString]
    def masterDatabaseNameValue: scala.Option[String]
    def hardwareValue: scala.Option[RelationalDatabaseHardware.ReadOnly]
    def stateValue: scala.Option[primitives.NonEmptyString]
    def secondaryAvailabilityZoneValue: scala.Option[String]
    def backupRetentionEnabledValue: scala.Option[Boolean]
    def pendingModifiedValuesValue: scala.Option[PendingModifiedRelationalDatabaseValues.ReadOnly]
    def engineValue: scala.Option[primitives.NonEmptyString]
    def engineVersionValue: scala.Option[primitives.NonEmptyString]
    def latestRestorableTimeValue: scala.Option[primitives.IsoDate]
    def masterUsernameValue: scala.Option[primitives.NonEmptyString]
    def parameterApplyStatusValue: scala.Option[primitives.NonEmptyString]
    def preferredBackupWindowValue: scala.Option[primitives.NonEmptyString]
    def preferredMaintenanceWindowValue: scala.Option[primitives.NonEmptyString]
    def publiclyAccessibleValue: scala.Option[Boolean]
    def masterEndpointValue: scala.Option[RelationalDatabaseEndpoint.ReadOnly]
    def pendingMaintenanceActionsValue: scala.Option[List[PendingMaintenanceAction.ReadOnly]]
    def caCertificateIdentifierValue: scala.Option[String]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def supportCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportCode", supportCodeValue)
    def createdAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceLocation.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def relationalDatabaseBlueprintId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("relationalDatabaseBlueprintId", relationalDatabaseBlueprintIdValue)
    def relationalDatabaseBundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("relationalDatabaseBundleId", relationalDatabaseBundleIdValue)
    def masterDatabaseName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterDatabaseName", masterDatabaseNameValue)
    def hardware: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RelationalDatabaseHardware.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hardware", hardwareValue)
    def state: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("state", stateValue)
    def secondaryAvailabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("secondaryAvailabilityZone", secondaryAvailabilityZoneValue)
    def backupRetentionEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionEnabled", backupRetentionEnabledValue)
    def pendingModifiedValues: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PendingModifiedRelationalDatabaseValues.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValuesValue)
    def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
    def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    def latestRestorableTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTimeValue)
    def masterUsername: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
    def parameterApplyStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatusValue)
    def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
    def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
    def publiclyAccessible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
    def masterEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RelationalDatabaseEndpoint.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterEndpoint", masterEndpointValue)
    def pendingMaintenanceActions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[PendingMaintenanceAction.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pendingMaintenanceActions", pendingMaintenanceActionsValue)
    def caCertificateIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("caCertificateIdentifier", caCertificateIdentifierValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabase) extends RelationalDatabase.ReadOnly {
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def arnValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.arn()).map(value => value: primitives.NonEmptyString)
    override def supportCodeValue: scala.Option[String] = scala.Option(impl.supportCode()).map(value => value: String)
    override def createdAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.createdAt()).map(value => value: primitives.IsoDate)
    override def locationValue: scala.Option[ResourceLocation.ReadOnly] = scala.Option(impl.location()).map(value => ResourceLocation.wrap(value))
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def relationalDatabaseBlueprintIdValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.relationalDatabaseBlueprintId()).map(value => value: primitives.NonEmptyString)
    override def relationalDatabaseBundleIdValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.relationalDatabaseBundleId()).map(value => value: primitives.NonEmptyString)
    override def masterDatabaseNameValue: scala.Option[String] = scala.Option(impl.masterDatabaseName()).map(value => value: String)
    override def hardwareValue: scala.Option[RelationalDatabaseHardware.ReadOnly] = scala.Option(impl.hardware()).map(value => RelationalDatabaseHardware.wrap(value))
    override def stateValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.state()).map(value => value: primitives.NonEmptyString)
    override def secondaryAvailabilityZoneValue: scala.Option[String] = scala.Option(impl.secondaryAvailabilityZone()).map(value => value: String)
    override def backupRetentionEnabledValue: scala.Option[Boolean] = scala.Option(impl.backupRetentionEnabled()).map(value => value: Boolean)
    override def pendingModifiedValuesValue: scala.Option[PendingModifiedRelationalDatabaseValues.ReadOnly] = scala.Option(impl.pendingModifiedValues()).map(value => PendingModifiedRelationalDatabaseValues.wrap(value))
    override def engineValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.engine()).map(value => value: primitives.NonEmptyString)
    override def engineVersionValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.engineVersion()).map(value => value: primitives.NonEmptyString)
    override def latestRestorableTimeValue: scala.Option[primitives.IsoDate] = scala.Option(impl.latestRestorableTime()).map(value => value: primitives.IsoDate)
    override def masterUsernameValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.masterUsername()).map(value => value: primitives.NonEmptyString)
    override def parameterApplyStatusValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.parameterApplyStatus()).map(value => value: primitives.NonEmptyString)
    override def preferredBackupWindowValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.preferredBackupWindow()).map(value => value: primitives.NonEmptyString)
    override def preferredMaintenanceWindowValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: primitives.NonEmptyString)
    override def publiclyAccessibleValue: scala.Option[Boolean] = scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
    override def masterEndpointValue: scala.Option[RelationalDatabaseEndpoint.ReadOnly] = scala.Option(impl.masterEndpoint()).map(value => RelationalDatabaseEndpoint.wrap(value))
    override def pendingMaintenanceActionsValue: scala.Option[List[PendingMaintenanceAction.ReadOnly]] = scala.Option(impl.pendingMaintenanceActions()).map(value => value.asScala.map { item => 
      PendingMaintenanceAction.wrap(item)
    }.toList)
    override def caCertificateIdentifierValue: scala.Option[String] = scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabase): ReadOnly = new Wrapper(impl)
}