package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Region(continentCode: scala.Option[String] = None, description: scala.Option[String] = None, displayName: scala.Option[String] = None, name: scala.Option[RegionName] = None, availabilityZones: scala.Option[Iterable[AvailabilityZone]] = None, relationalDatabaseAvailabilityZones: scala.Option[Iterable[AvailabilityZone]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Region = {
    import Region.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Region.builder().optionallyWith(continentCode.map(value => value: java.lang.String))(_.continentCode).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(displayName.map(value => value: java.lang.String))(_.displayName).optionallyWith(name.map(value => value.unwrap))(_.name).optionallyWith(availabilityZones.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.availabilityZones).optionallyWith(relationalDatabaseAvailabilityZones.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.relationalDatabaseAvailabilityZones).build()
  }
  def asReadOnly: Region.ReadOnly = Region.wrap(buildAwsValue())
}
object Region {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.Region] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Region = Region(continentCodeValue.map(value => value), descriptionValue.map(value => value), displayNameValue.map(value => value), nameValue.map(value => value), availabilityZonesValue.map(value => value.map { item => 
      item.editable
    }), relationalDatabaseAvailabilityZonesValue.map(value => value.map { item => 
      item.editable
    }))
    def continentCodeValue: scala.Option[String]
    def descriptionValue: scala.Option[String]
    def displayNameValue: scala.Option[String]
    def nameValue: scala.Option[RegionName]
    def availabilityZonesValue: scala.Option[List[AvailabilityZone.ReadOnly]]
    def relationalDatabaseAvailabilityZonesValue: scala.Option[List[AvailabilityZone.ReadOnly]]
    def continentCode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("continentCode", continentCodeValue)
    def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
    def displayName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("displayName", displayNameValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RegionName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def availabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AvailabilityZone.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZones", availabilityZonesValue)
    def relationalDatabaseAvailabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AvailabilityZone.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("relationalDatabaseAvailabilityZones", relationalDatabaseAvailabilityZonesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.Region) extends Region.ReadOnly {
    override def continentCodeValue: scala.Option[String] = scala.Option(impl.continentCode()).map(value => value: String)
    override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
    override def displayNameValue: scala.Option[String] = scala.Option(impl.displayName()).map(value => value: String)
    override def nameValue: scala.Option[RegionName] = scala.Option(impl.name()).map(value => RegionName.wrap(value))
    override def availabilityZonesValue: scala.Option[List[AvailabilityZone.ReadOnly]] = scala.Option(impl.availabilityZones()).map(value => value.asScala.map { item => 
      AvailabilityZone.wrap(item)
    }.toList)
    override def relationalDatabaseAvailabilityZonesValue: scala.Option[List[AvailabilityZone.ReadOnly]] = scala.Option(impl.relationalDatabaseAvailabilityZones()).map(value => value.asScala.map { item => 
      AvailabilityZone.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.Region): ReadOnly = new Wrapper(impl)
}