package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class MonitoredResourceInfo(arn: scala.Option[primitives.ResourceArn] = None, name: scala.Option[primitives.ResourceName] = None, resourceType: scala.Option[ResourceType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo = {
    import MonitoredResourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo.builder().optionallyWith(arn.map(value => value: java.lang.String))(_.arn).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType).build()
  }
  def asReadOnly: MonitoredResourceInfo.ReadOnly = MonitoredResourceInfo.wrap(buildAwsValue())
}
object MonitoredResourceInfo {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: MonitoredResourceInfo = MonitoredResourceInfo(arnValue.map(value => value), nameValue.map(value => value), resourceTypeValue.map(value => value))
    def arnValue: scala.Option[primitives.ResourceArn]
    def nameValue: scala.Option[primitives.ResourceName]
    def resourceTypeValue: scala.Option[ResourceType]
    def arn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("arn", arnValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def resourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceType", resourceTypeValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo) extends MonitoredResourceInfo.ReadOnly {
    override def arnValue: scala.Option[primitives.ResourceArn] = scala.Option(impl.arn()).map(value => value: primitives.ResourceArn)
    override def nameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.name()).map(value => value: primitives.ResourceName)
    override def resourceTypeValue: scala.Option[ResourceType] = scala.Option(impl.resourceType()).map(value => ResourceType.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.MonitoredResourceInfo): ReadOnly = new Wrapper(impl)
}