package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait LoadBalancerProtocol { def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol }
object LoadBalancerProtocol {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol): LoadBalancerProtocol = value match {
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.HTTP_HTTPS =>
      val r = HTTP_HTTPS
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.HTTP =>
      val r = HTTP
      r
  }
  case object unknownToSdkVersion extends LoadBalancerProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol = software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.UNKNOWN_TO_SDK_VERSION }
  case object HTTP_HTTPS extends LoadBalancerProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol = software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.HTTP_HTTPS }
  case object HTTP extends LoadBalancerProtocol { override def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol = software.amazon.awssdk.services.lightsail.model.LoadBalancerProtocol.HTTP }
}