package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class InstanceHealthSummary(instanceName: scala.Option[primitives.ResourceName] = None, instanceHealth: scala.Option[InstanceHealthState] = None, instanceHealthReason: scala.Option[InstanceHealthReason] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary = {
    import InstanceHealthSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary.builder().optionallyWith(instanceName.map(value => value: java.lang.String))(_.instanceName).optionallyWith(instanceHealth.map(value => value.unwrap))(_.instanceHealth).optionallyWith(instanceHealthReason.map(value => value.unwrap))(_.instanceHealthReason).build()
  }
  def asReadOnly: InstanceHealthSummary.ReadOnly = InstanceHealthSummary.wrap(buildAwsValue())
}
object InstanceHealthSummary {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: InstanceHealthSummary = InstanceHealthSummary(instanceNameValue.map(value => value), instanceHealthValue.map(value => value), instanceHealthReasonValue.map(value => value))
    def instanceNameValue: scala.Option[primitives.ResourceName]
    def instanceHealthValue: scala.Option[InstanceHealthState]
    def instanceHealthReasonValue: scala.Option[InstanceHealthReason]
    def instanceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceName", instanceNameValue)
    def instanceHealth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceHealthState] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceHealth", instanceHealthValue)
    def instanceHealthReason: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstanceHealthReason] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceHealthReason", instanceHealthReasonValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary) extends InstanceHealthSummary.ReadOnly {
    override def instanceNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.instanceName()).map(value => value: primitives.ResourceName)
    override def instanceHealthValue: scala.Option[InstanceHealthState] = scala.Option(impl.instanceHealth()).map(value => InstanceHealthState.wrap(value))
    override def instanceHealthReasonValue: scala.Option[InstanceHealthReason] = scala.Option(impl.instanceHealthReason()).map(value => InstanceHealthReason.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary): ReadOnly = new Wrapper(impl)
}