package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class HostKeyAttributes(algorithm: scala.Option[String] = None, publicKey: scala.Option[String] = None, witnessedAt: scala.Option[primitives.IsoDate] = None, fingerprintSHA1: scala.Option[String] = None, fingerprintSHA256: scala.Option[String] = None, notValidBefore: scala.Option[primitives.IsoDate] = None, notValidAfter: scala.Option[primitives.IsoDate] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.HostKeyAttributes = {
    import HostKeyAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.HostKeyAttributes.builder().optionallyWith(algorithm.map(value => value: java.lang.String))(_.algorithm).optionallyWith(publicKey.map(value => value: java.lang.String))(_.publicKey).optionallyWith(witnessedAt.map(value => value: java.time.Instant))(_.witnessedAt).optionallyWith(fingerprintSHA1.map(value => value: java.lang.String))(_.fingerprintSHA1).optionallyWith(fingerprintSHA256.map(value => value: java.lang.String))(_.fingerprintSHA256).optionallyWith(notValidBefore.map(value => value: java.time.Instant))(_.notValidBefore).optionallyWith(notValidAfter.map(value => value: java.time.Instant))(_.notValidAfter).build()
  }
  def asReadOnly: HostKeyAttributes.ReadOnly = HostKeyAttributes.wrap(buildAwsValue())
}
object HostKeyAttributes {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.HostKeyAttributes] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: HostKeyAttributes = HostKeyAttributes(algorithmValue.map(value => value), publicKeyValue.map(value => value), witnessedAtValue.map(value => value), fingerprintSHA1Value.map(value => value), fingerprintSHA256Value.map(value => value), notValidBeforeValue.map(value => value), notValidAfterValue.map(value => value))
    def algorithmValue: scala.Option[String]
    def publicKeyValue: scala.Option[String]
    def witnessedAtValue: scala.Option[primitives.IsoDate]
    def fingerprintSHA1Value: scala.Option[String]
    def fingerprintSHA256Value: scala.Option[String]
    def notValidBeforeValue: scala.Option[primitives.IsoDate]
    def notValidAfterValue: scala.Option[primitives.IsoDate]
    def algorithm: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("algorithm", algorithmValue)
    def publicKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publicKey", publicKeyValue)
    def witnessedAt: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("witnessedAt", witnessedAtValue)
    def fingerprintSHA1: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fingerprintSHA1", fingerprintSHA1Value)
    def fingerprintSHA256: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fingerprintSHA256", fingerprintSHA256Value)
    def notValidBefore: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notValidBefore", notValidBeforeValue)
    def notValidAfter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IsoDate] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("notValidAfter", notValidAfterValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.HostKeyAttributes) extends HostKeyAttributes.ReadOnly {
    override def algorithmValue: scala.Option[String] = scala.Option(impl.algorithm()).map(value => value: String)
    override def publicKeyValue: scala.Option[String] = scala.Option(impl.publicKey()).map(value => value: String)
    override def witnessedAtValue: scala.Option[primitives.IsoDate] = scala.Option(impl.witnessedAt()).map(value => value: primitives.IsoDate)
    override def fingerprintSHA1Value: scala.Option[String] = scala.Option(impl.fingerprintSHA1()).map(value => value: String)
    override def fingerprintSHA256Value: scala.Option[String] = scala.Option(impl.fingerprintSHA256()).map(value => value: String)
    override def notValidBeforeValue: scala.Option[primitives.IsoDate] = scala.Option(impl.notValidBefore()).map(value => value: primitives.IsoDate)
    override def notValidAfterValue: scala.Option[primitives.IsoDate] = scala.Option(impl.notValidAfter()).map(value => value: primitives.IsoDate)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.HostKeyAttributes): ReadOnly = new Wrapper(impl)
}