package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseRequest(relationalDatabaseName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest = {
    import GetRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).build()
  }
  def asReadOnly: GetRelationalDatabaseRequest.ReadOnly = GetRelationalDatabaseRequest.wrap(buildAwsValue())
}
object GetRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseRequest = GetRelationalDatabaseRequest(relationalDatabaseNameValue)
    def relationalDatabaseNameValue: primitives.ResourceName
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest) extends GetRelationalDatabaseRequest.ReadOnly { override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseRequest): ReadOnly = new Wrapper(impl)
}