package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseParametersRequest(relationalDatabaseName: primitives.ResourceName, pageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest = {
    import GetRelationalDatabaseParametersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest.builder().relationalDatabaseName(relationalDatabaseName: java.lang.String).optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).build()
  }
  def asReadOnly: GetRelationalDatabaseParametersRequest.ReadOnly = GetRelationalDatabaseParametersRequest.wrap(buildAwsValue())
}
object GetRelationalDatabaseParametersRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseParametersRequest = GetRelationalDatabaseParametersRequest(relationalDatabaseNameValue, pageTokenValue.map(value => value))
    def relationalDatabaseNameValue: primitives.ResourceName
    def pageTokenValue: scala.Option[String]
    def relationalDatabaseName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(relationalDatabaseNameValue)
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest) extends GetRelationalDatabaseParametersRequest.ReadOnly {
    override def relationalDatabaseNameValue: primitives.ResourceName = impl.relationalDatabaseName(): primitives.ResourceName
    override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersRequest): ReadOnly = new Wrapper(impl)
}