package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRelationalDatabaseBlueprintsResponse(blueprints: scala.Option[Iterable[RelationalDatabaseBlueprint]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse = {
    import GetRelationalDatabaseBlueprintsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse.builder().optionallyWith(blueprints.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.blueprints).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetRelationalDatabaseBlueprintsResponse.ReadOnly = GetRelationalDatabaseBlueprintsResponse.wrap(buildAwsValue())
}
object GetRelationalDatabaseBlueprintsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRelationalDatabaseBlueprintsResponse = GetRelationalDatabaseBlueprintsResponse(blueprintsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def blueprintsValue: scala.Option[List[RelationalDatabaseBlueprint.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def blueprints: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RelationalDatabaseBlueprint.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("blueprints", blueprintsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse) extends GetRelationalDatabaseBlueprintsResponse.ReadOnly {
    override def blueprintsValue: scala.Option[List[RelationalDatabaseBlueprint.ReadOnly]] = scala.Option(impl.blueprints()).map(value => value.asScala.map { item => 
      RelationalDatabaseBlueprint.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse): ReadOnly = new Wrapper(impl)
}