package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRegionsRequest(includeAvailabilityZones: scala.Option[Boolean] = None, includeRelationalDatabaseAvailabilityZones: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetRegionsRequest = {
    import GetRegionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRegionsRequest.builder().optionallyWith(includeAvailabilityZones.map(value => value: java.lang.Boolean))(_.includeAvailabilityZones).optionallyWith(includeRelationalDatabaseAvailabilityZones.map(value => value: java.lang.Boolean))(_.includeRelationalDatabaseAvailabilityZones).build()
  }
  def asReadOnly: GetRegionsRequest.ReadOnly = GetRegionsRequest.wrap(buildAwsValue())
}
object GetRegionsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetRegionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRegionsRequest = GetRegionsRequest(includeAvailabilityZonesValue.map(value => value), includeRelationalDatabaseAvailabilityZonesValue.map(value => value))
    def includeAvailabilityZonesValue: scala.Option[Boolean]
    def includeRelationalDatabaseAvailabilityZonesValue: scala.Option[Boolean]
    def includeAvailabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includeAvailabilityZones", includeAvailabilityZonesValue)
    def includeRelationalDatabaseAvailabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includeRelationalDatabaseAvailabilityZones", includeRelationalDatabaseAvailabilityZonesValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetRegionsRequest) extends GetRegionsRequest.ReadOnly {
    override def includeAvailabilityZonesValue: scala.Option[Boolean] = scala.Option(impl.includeAvailabilityZones()).map(value => value: Boolean)
    override def includeRelationalDatabaseAvailabilityZonesValue: scala.Option[Boolean] = scala.Option(impl.includeRelationalDatabaseAvailabilityZones()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetRegionsRequest): ReadOnly = new Wrapper(impl)
}