package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetOperationsForResourceRequest(resourceName: primitives.ResourceName, pageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest = {
    import GetOperationsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest.builder().resourceName(resourceName: java.lang.String).optionallyWith(pageToken.map(value => value: java.lang.String))(_.pageToken).build()
  }
  def asReadOnly: GetOperationsForResourceRequest.ReadOnly = GetOperationsForResourceRequest.wrap(buildAwsValue())
}
object GetOperationsForResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetOperationsForResourceRequest = GetOperationsForResourceRequest(resourceNameValue, pageTokenValue.map(value => value))
    def resourceNameValue: primitives.ResourceName
    def pageTokenValue: scala.Option[String]
    def resourceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(resourceNameValue)
    def pageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest) extends GetOperationsForResourceRequest.ReadOnly {
    override def resourceNameValue: primitives.ResourceName = impl.resourceName(): primitives.ResourceName
    override def pageTokenValue: scala.Option[String] = scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest): ReadOnly = new Wrapper(impl)
}