package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetInstanceSnapshotsResponse(instanceSnapshots: scala.Option[Iterable[InstanceSnapshot]] = None, nextPageToken: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse = {
    import GetInstanceSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse.builder().optionallyWith(instanceSnapshots.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.instanceSnapshots).optionallyWith(nextPageToken.map(value => value: java.lang.String))(_.nextPageToken).build()
  }
  def asReadOnly: GetInstanceSnapshotsResponse.ReadOnly = GetInstanceSnapshotsResponse.wrap(buildAwsValue())
}
object GetInstanceSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetInstanceSnapshotsResponse = GetInstanceSnapshotsResponse(instanceSnapshotsValue.map(value => value.map { item => 
      item.editable
    }), nextPageTokenValue.map(value => value))
    def instanceSnapshotsValue: scala.Option[List[InstanceSnapshot.ReadOnly]]
    def nextPageTokenValue: scala.Option[String]
    def instanceSnapshots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[InstanceSnapshot.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceSnapshots", instanceSnapshotsValue)
    def nextPageToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse) extends GetInstanceSnapshotsResponse.ReadOnly {
    override def instanceSnapshotsValue: scala.Option[List[InstanceSnapshot.ReadOnly]] = scala.Option(impl.instanceSnapshots()).map(value => value.asScala.map { item => 
      InstanceSnapshot.wrap(item)
    }.toList)
    override def nextPageTokenValue: scala.Option[String] = scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsResponse): ReadOnly = new Wrapper(impl)
}