package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetContainerServicesRequest(serviceName: scala.Option[primitives.ContainerServiceName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest = {
    import GetContainerServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest.builder().optionallyWith(serviceName.map(value => value: java.lang.String))(_.serviceName).build()
  }
  def asReadOnly: GetContainerServicesRequest.ReadOnly = GetContainerServicesRequest.wrap(buildAwsValue())
}
object GetContainerServicesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetContainerServicesRequest = GetContainerServicesRequest(serviceNameValue.map(value => value))
    def serviceNameValue: scala.Option[primitives.ContainerServiceName]
    def serviceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ContainerServiceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("serviceName", serviceNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest) extends GetContainerServicesRequest.ReadOnly { override def serviceNameValue: scala.Option[primitives.ContainerServiceName] = scala.Option(impl.serviceName()).map(value => value: primitives.ContainerServiceName) }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.GetContainerServicesRequest): ReadOnly = new Wrapper(impl)
}