package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteLoadBalancerRequest(loadBalancerName: primitives.ResourceName) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest = {
    import DeleteLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest.builder().loadBalancerName(loadBalancerName: java.lang.String).build()
  }
  def asReadOnly: DeleteLoadBalancerRequest.ReadOnly = DeleteLoadBalancerRequest.wrap(buildAwsValue())
}
object DeleteLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteLoadBalancerRequest = DeleteLoadBalancerRequest(loadBalancerNameValue)
    def loadBalancerNameValue: primitives.ResourceName
    def loadBalancerName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(loadBalancerNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest) extends DeleteLoadBalancerRequest.ReadOnly { override def loadBalancerNameValue: primitives.ResourceName = impl.loadBalancerName(): primitives.ResourceName }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteLoadBalancerRequest): ReadOnly = new Wrapper(impl)
}