package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class DeleteAutoSnapshotRequest(resourceName: primitives.ResourceName, date: primitives.AutoSnapshotDate) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest = {
    import DeleteAutoSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest.builder().resourceName(resourceName: java.lang.String).date(date: java.lang.String).build()
  }
  def asReadOnly: DeleteAutoSnapshotRequest.ReadOnly = DeleteAutoSnapshotRequest.wrap(buildAwsValue())
}
object DeleteAutoSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: DeleteAutoSnapshotRequest = DeleteAutoSnapshotRequest(resourceNameValue, dateValue)
    def resourceNameValue: primitives.ResourceName
    def dateValue: primitives.AutoSnapshotDate
    def resourceName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(resourceNameValue)
    def date: ZIO[Any, Nothing, primitives.AutoSnapshotDate] = ZIO.succeed(dateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest) extends DeleteAutoSnapshotRequest.ReadOnly {
    override def resourceNameValue: primitives.ResourceName = impl.resourceName(): primitives.ResourceName
    override def dateValue: primitives.AutoSnapshotDate = impl.date(): primitives.AutoSnapshotDate
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest): ReadOnly = new Wrapper(impl)
}