package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateKeyPairRequest(keyPairName: primitives.ResourceName, tags: scala.Option[Iterable[Tag]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest = {
    import CreateKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest.builder().keyPairName(keyPairName: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).build()
  }
  def asReadOnly: CreateKeyPairRequest.ReadOnly = CreateKeyPairRequest.wrap(buildAwsValue())
}
object CreateKeyPairRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateKeyPairRequest = CreateKeyPairRequest(keyPairNameValue, tagsValue.map(value => value.map { item => 
      item.editable
    }))
    def keyPairNameValue: primitives.ResourceName
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def keyPairName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(keyPairNameValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest) extends CreateKeyPairRequest.ReadOnly {
    override def keyPairNameValue: primitives.ResourceName = impl.keyPairName(): primitives.ResourceName
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairRequest): ReadOnly = new Wrapper(impl)
}