package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateInstancesFromSnapshotRequest(instanceNames: Iterable[String], attachedDiskMapping: scala.Option[Map[primitives.ResourceName, Iterable[DiskMap]]] = None, availabilityZone: String, instanceSnapshotName: scala.Option[primitives.ResourceName] = None, bundleId: primitives.NonEmptyString, userData: scala.Option[String] = None, keyPairName: scala.Option[primitives.ResourceName] = None, tags: scala.Option[Iterable[Tag]] = None, addOns: scala.Option[Iterable[AddOnRequest]] = None, ipAddressType: scala.Option[IpAddressType] = None, sourceInstanceName: scala.Option[String] = None, restoreDate: scala.Option[String] = None, useLatestRestorableAutoSnapshot: scala.Option[Boolean] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest = {
    import CreateInstancesFromSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest.builder().instanceNames(instanceNames.map { item => 
      item: java.lang.String
    }.asJavaCollection).optionallyWith(attachedDiskMapping.map(value => value.map({
      case (key, value) =>
        (key: java.lang.String) -> value.map { item => 
          item.buildAwsValue()
        }.asJavaCollection
    }).asJava))(_.attachedDiskMapping).availabilityZone(availabilityZone: java.lang.String).optionallyWith(instanceSnapshotName.map(value => value: java.lang.String))(_.instanceSnapshotName).bundleId(bundleId: java.lang.String).optionallyWith(userData.map(value => value: java.lang.String))(_.userData).optionallyWith(keyPairName.map(value => value: java.lang.String))(_.keyPairName).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(addOns.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.addOns).optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType).optionallyWith(sourceInstanceName.map(value => value: java.lang.String))(_.sourceInstanceName).optionallyWith(restoreDate.map(value => value: java.lang.String))(_.restoreDate).optionallyWith(useLatestRestorableAutoSnapshot.map(value => value: java.lang.Boolean))(_.useLatestRestorableAutoSnapshot).build()
  }
  def asReadOnly: CreateInstancesFromSnapshotRequest.ReadOnly = CreateInstancesFromSnapshotRequest.wrap(buildAwsValue())
}
object CreateInstancesFromSnapshotRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateInstancesFromSnapshotRequest = CreateInstancesFromSnapshotRequest(instanceNamesValue, attachedDiskMappingValue.map(value => value.map({
      case (key, value) =>
        key -> value.map { item => 
          item.editable
        }
    })), availabilityZoneValue, instanceSnapshotNameValue.map(value => value), bundleIdValue, userDataValue.map(value => value), keyPairNameValue.map(value => value), tagsValue.map(value => value.map { item => 
      item.editable
    }), addOnsValue.map(value => value.map { item => 
      item.editable
    }), ipAddressTypeValue.map(value => value), sourceInstanceNameValue.map(value => value), restoreDateValue.map(value => value), useLatestRestorableAutoSnapshotValue.map(value => value))
    def instanceNamesValue: List[String]
    def attachedDiskMappingValue: scala.Option[Map[primitives.ResourceName, List[DiskMap.ReadOnly]]]
    def availabilityZoneValue: String
    def instanceSnapshotNameValue: scala.Option[primitives.ResourceName]
    def bundleIdValue: primitives.NonEmptyString
    def userDataValue: scala.Option[String]
    def keyPairNameValue: scala.Option[primitives.ResourceName]
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def addOnsValue: scala.Option[List[AddOnRequest.ReadOnly]]
    def ipAddressTypeValue: scala.Option[IpAddressType]
    def sourceInstanceNameValue: scala.Option[String]
    def restoreDateValue: scala.Option[String]
    def useLatestRestorableAutoSnapshotValue: scala.Option[Boolean]
    def instanceNames: ZIO[Any, Nothing, List[String]] = ZIO.succeed(instanceNamesValue)
    def attachedDiskMapping: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Map[primitives.ResourceName, List[DiskMap.ReadOnly]]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attachedDiskMapping", attachedDiskMappingValue)
    def availabilityZone: ZIO[Any, Nothing, String] = ZIO.succeed(availabilityZoneValue)
    def instanceSnapshotName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceSnapshotName", instanceSnapshotNameValue)
    def bundleId: ZIO[Any, Nothing, primitives.NonEmptyString] = ZIO.succeed(bundleIdValue)
    def userData: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("userData", userDataValue)
    def keyPairName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ResourceName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("keyPairName", keyPairNameValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def addOns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AddOnRequest.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addOns", addOnsValue)
    def ipAddressType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, IpAddressType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
    def sourceInstanceName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceInstanceName", sourceInstanceNameValue)
    def restoreDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("restoreDate", restoreDateValue)
    def useLatestRestorableAutoSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("useLatestRestorableAutoSnapshot", useLatestRestorableAutoSnapshotValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest) extends CreateInstancesFromSnapshotRequest.ReadOnly {
    override def instanceNamesValue: List[String] = impl.instanceNames().asScala.map { item => 
      item: String
    }.toList
    override def attachedDiskMappingValue: scala.Option[Map[primitives.ResourceName, List[DiskMap.ReadOnly]]] = scala.Option(impl.attachedDiskMapping()).map(value => value.asScala.map({
      case (key, value) =>
        (key: primitives.ResourceName) -> value.asScala.map { item => 
          DiskMap.wrap(item)
        }.toList
    }).toMap)
    override def availabilityZoneValue: String = impl.availabilityZone(): String
    override def instanceSnapshotNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.instanceSnapshotName()).map(value => value: primitives.ResourceName)
    override def bundleIdValue: primitives.NonEmptyString = impl.bundleId(): primitives.NonEmptyString
    override def userDataValue: scala.Option[String] = scala.Option(impl.userData()).map(value => value: String)
    override def keyPairNameValue: scala.Option[primitives.ResourceName] = scala.Option(impl.keyPairName()).map(value => value: primitives.ResourceName)
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def addOnsValue: scala.Option[List[AddOnRequest.ReadOnly]] = scala.Option(impl.addOns()).map(value => value.asScala.map { item => 
      AddOnRequest.wrap(item)
    }.toList)
    override def ipAddressTypeValue: scala.Option[IpAddressType] = scala.Option(impl.ipAddressType()).map(value => IpAddressType.wrap(value))
    override def sourceInstanceNameValue: scala.Option[String] = scala.Option(impl.sourceInstanceName()).map(value => value: String)
    override def restoreDateValue: scala.Option[String] = scala.Option(impl.restoreDate()).map(value => value: String)
    override def useLatestRestorableAutoSnapshotValue: scala.Option[Boolean] = scala.Option(impl.useLatestRestorableAutoSnapshot()).map(value => value: Boolean)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateInstancesFromSnapshotRequest): ReadOnly = new Wrapper(impl)
}