package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class CreateDiskRequest(diskName: primitives.ResourceName, availabilityZone: primitives.NonEmptyString, sizeInGb: primitives.Integer, tags: scala.Option[Iterable[Tag]] = None, addOns: scala.Option[Iterable[AddOnRequest]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.CreateDiskRequest = {
    import CreateDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDiskRequest.builder().diskName(diskName: java.lang.String).availabilityZone(availabilityZone: java.lang.String).sizeInGb(sizeInGb: java.lang.Integer).optionallyWith(tags.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.tags).optionallyWith(addOns.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.addOns).build()
  }
  def asReadOnly: CreateDiskRequest.ReadOnly = CreateDiskRequest.wrap(buildAwsValue())
}
object CreateDiskRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.CreateDiskRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: CreateDiskRequest = CreateDiskRequest(diskNameValue, availabilityZoneValue, sizeInGbValue, tagsValue.map(value => value.map { item => 
      item.editable
    }), addOnsValue.map(value => value.map { item => 
      item.editable
    }))
    def diskNameValue: primitives.ResourceName
    def availabilityZoneValue: primitives.NonEmptyString
    def sizeInGbValue: primitives.Integer
    def tagsValue: scala.Option[List[Tag.ReadOnly]]
    def addOnsValue: scala.Option[List[AddOnRequest.ReadOnly]]
    def diskName: ZIO[Any, Nothing, primitives.ResourceName] = ZIO.succeed(diskNameValue)
    def availabilityZone: ZIO[Any, Nothing, primitives.NonEmptyString] = ZIO.succeed(availabilityZoneValue)
    def sizeInGb: ZIO[Any, Nothing, primitives.Integer] = ZIO.succeed(sizeInGbValue)
    def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    def addOns: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AddOnRequest.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("addOns", addOnsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.CreateDiskRequest) extends CreateDiskRequest.ReadOnly {
    override def diskNameValue: primitives.ResourceName = impl.diskName(): primitives.ResourceName
    override def availabilityZoneValue: primitives.NonEmptyString = impl.availabilityZone(): primitives.NonEmptyString
    override def sizeInGbValue: primitives.Integer = impl.sizeInGb(): primitives.Integer
    override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
      Tag.wrap(item)
    }.toList)
    override def addOnsValue: scala.Option[List[AddOnRequest.ReadOnly]] = scala.Option(impl.addOns()).map(value => value.asScala.map { item => 
      AddOnRequest.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.CreateDiskRequest): ReadOnly = new Wrapper(impl)
}