package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait CertificateStatus { def unwrap: software.amazon.awssdk.services.lightsail.model.CertificateStatus }
object CertificateStatus {
  def wrap(value: software.amazon.awssdk.services.lightsail.model.CertificateStatus): CertificateStatus = value match {
    case software.amazon.awssdk.services.lightsail.model.CertificateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.CertificateStatus.PENDING_VALIDATION =>
      val r = PENDING_VALIDATION
      r
    case software.amazon.awssdk.services.lightsail.model.CertificateStatus.ISSUED =>
      val r = ISSUED
      r
    case software.amazon.awssdk.services.lightsail.model.CertificateStatus.INACTIVE =>
      val r = INACTIVE
      r
    case software.amazon.awssdk.services.lightsail.model.CertificateStatus.EXPIRED =>
      val r = EXPIRED
      r
    case software.amazon.awssdk.services.lightsail.model.CertificateStatus.VALIDATION_TIMED_OUT =>
      val r = VALIDATION_TIMED_OUT
      r
    case software.amazon.awssdk.services.lightsail.model.CertificateStatus.REVOKED =>
      val r = REVOKED
      r
    case software.amazon.awssdk.services.lightsail.model.CertificateStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends CertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.CertificateStatus = software.amazon.awssdk.services.lightsail.model.CertificateStatus.UNKNOWN_TO_SDK_VERSION }
  case object PENDING_VALIDATION extends CertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.CertificateStatus = software.amazon.awssdk.services.lightsail.model.CertificateStatus.PENDING_VALIDATION }
  case object ISSUED extends CertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.CertificateStatus = software.amazon.awssdk.services.lightsail.model.CertificateStatus.ISSUED }
  case object INACTIVE extends CertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.CertificateStatus = software.amazon.awssdk.services.lightsail.model.CertificateStatus.INACTIVE }
  case object EXPIRED extends CertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.CertificateStatus = software.amazon.awssdk.services.lightsail.model.CertificateStatus.EXPIRED }
  case object VALIDATION_TIMED_OUT extends CertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.CertificateStatus = software.amazon.awssdk.services.lightsail.model.CertificateStatus.VALIDATION_TIMED_OUT }
  case object REVOKED extends CertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.CertificateStatus = software.amazon.awssdk.services.lightsail.model.CertificateStatus.REVOKED }
  case object FAILED extends CertificateStatus { override def unwrap: software.amazon.awssdk.services.lightsail.model.CertificateStatus = software.amazon.awssdk.services.lightsail.model.CertificateStatus.FAILED }
}