package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Bundle(price: scala.Option[Float] = None, cpuCount: scala.Option[primitives.Integer] = None, diskSizeInGb: scala.Option[primitives.Integer] = None, bundleId: scala.Option[primitives.NonEmptyString] = None, instanceType: scala.Option[String] = None, isActive: scala.Option[Boolean] = None, name: scala.Option[String] = None, power: scala.Option[primitives.Integer] = None, ramSizeInGb: scala.Option[Float] = None, transferPerMonthInGb: scala.Option[primitives.Integer] = None, supportedPlatforms: scala.Option[Iterable[InstancePlatform]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.Bundle = {
    import Bundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Bundle.builder().optionallyWith(price.map(value => value: java.lang.Float))(_.price).optionallyWith(cpuCount.map(value => value: java.lang.Integer))(_.cpuCount).optionallyWith(diskSizeInGb.map(value => value: java.lang.Integer))(_.diskSizeInGb).optionallyWith(bundleId.map(value => value: java.lang.String))(_.bundleId).optionallyWith(instanceType.map(value => value: java.lang.String))(_.instanceType).optionallyWith(isActive.map(value => value: java.lang.Boolean))(_.isActive).optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(power.map(value => value: java.lang.Integer))(_.power).optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(_.ramSizeInGb).optionallyWith(transferPerMonthInGb.map(value => value: java.lang.Integer))(_.transferPerMonthInGb).optionallyWith(supportedPlatforms.map(value => value.map { item => 
      item.unwrap.toString
    }.asJavaCollection))(_.supportedPlatformsWithStrings).build()
  }
  def asReadOnly: Bundle.ReadOnly = Bundle.wrap(buildAwsValue())
}
object Bundle {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.Bundle] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Bundle = Bundle(priceValue.map(value => value), cpuCountValue.map(value => value), diskSizeInGbValue.map(value => value), bundleIdValue.map(value => value), instanceTypeValue.map(value => value), isActiveValue.map(value => value), nameValue.map(value => value), powerValue.map(value => value), ramSizeInGbValue.map(value => value), transferPerMonthInGbValue.map(value => value), supportedPlatformsValue.map(value => value))
    def priceValue: scala.Option[Float]
    def cpuCountValue: scala.Option[primitives.Integer]
    def diskSizeInGbValue: scala.Option[primitives.Integer]
    def bundleIdValue: scala.Option[primitives.NonEmptyString]
    def instanceTypeValue: scala.Option[String]
    def isActiveValue: scala.Option[Boolean]
    def nameValue: scala.Option[String]
    def powerValue: scala.Option[primitives.Integer]
    def ramSizeInGbValue: scala.Option[Float]
    def transferPerMonthInGbValue: scala.Option[primitives.Integer]
    def supportedPlatformsValue: scala.Option[List[InstancePlatform]]
    def price: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Float] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("price", priceValue)
    def cpuCount: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cpuCount", cpuCountValue)
    def diskSizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("diskSizeInGb", diskSizeInGbValue)
    def bundleId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NonEmptyString] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def instanceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceType", instanceTypeValue)
    def isActive: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isActive", isActiveValue)
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def power: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("power", powerValue)
    def ramSizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Float] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGbValue)
    def transferPerMonthInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("transferPerMonthInGb", transferPerMonthInGbValue)
    def supportedPlatforms: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[InstancePlatform]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportedPlatforms", supportedPlatformsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.Bundle) extends Bundle.ReadOnly {
    override def priceValue: scala.Option[Float] = scala.Option(impl.price()).map(value => value: Float)
    override def cpuCountValue: scala.Option[primitives.Integer] = scala.Option(impl.cpuCount()).map(value => value: primitives.Integer)
    override def diskSizeInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.diskSizeInGb()).map(value => value: primitives.Integer)
    override def bundleIdValue: scala.Option[primitives.NonEmptyString] = scala.Option(impl.bundleId()).map(value => value: primitives.NonEmptyString)
    override def instanceTypeValue: scala.Option[String] = scala.Option(impl.instanceType()).map(value => value: String)
    override def isActiveValue: scala.Option[Boolean] = scala.Option(impl.isActive()).map(value => value: Boolean)
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
    override def powerValue: scala.Option[primitives.Integer] = scala.Option(impl.power()).map(value => value: primitives.Integer)
    override def ramSizeInGbValue: scala.Option[Float] = scala.Option(impl.ramSizeInGb()).map(value => value: Float)
    override def transferPerMonthInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.transferPerMonthInGb()).map(value => value: primitives.Integer)
    override def supportedPlatformsValue: scala.Option[List[InstancePlatform]] = scala.Option(impl.supportedPlatforms()).map(value => value.asScala.map { item => 
      InstancePlatform.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.Bundle): ReadOnly = new Wrapper(impl)
}