package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AttachedDisk(path: scala.Option[String] = None, sizeInGb: scala.Option[primitives.Integer] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.AttachedDisk = {
    import AttachedDisk.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AttachedDisk.builder().optionallyWith(path.map(value => value: java.lang.String))(_.path).optionallyWith(sizeInGb.map(value => value: java.lang.Integer))(_.sizeInGb).build()
  }
  def asReadOnly: AttachedDisk.ReadOnly = AttachedDisk.wrap(buildAwsValue())
}
object AttachedDisk {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.AttachedDisk] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AttachedDisk = AttachedDisk(pathValue.map(value => value), sizeInGbValue.map(value => value))
    def pathValue: scala.Option[String]
    def sizeInGbValue: scala.Option[primitives.Integer]
    def path: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("path", pathValue)
    def sizeInGb: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sizeInGb", sizeInGbValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.AttachedDisk) extends AttachedDisk.ReadOnly {
    override def pathValue: scala.Option[String] = scala.Option(impl.path()).map(value => value: String)
    override def sizeInGbValue: scala.Option[primitives.Integer] = scala.Option(impl.sizeInGb()).map(value => value: primitives.Integer)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.AttachedDisk): ReadOnly = new Wrapper(impl)
}