package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ResourceRecord(name: scala.Option[String] = None, `type`: scala.Option[String] = None, value: scala.Option[String] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.lightsail.model.ResourceRecord = {
    import ResourceRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ResourceRecord.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`).optionallyWith(value.map(value => value: java.lang.String))(_.value).build()
  }
  def asReadOnly: ResourceRecord.ReadOnly = ResourceRecord.wrap(buildAwsValue())
}
object ResourceRecord {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.lightsail.model.ResourceRecord] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ResourceRecord = ResourceRecord(nameValue.map(value => value), typeValue.map(value => value), valueValue.map(value => value))
    def nameValue: scala.Option[String]
    def typeValue: scala.Option[String]
    def valueValue: scala.Option[String]
    def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    def `type`: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("type", typeValue)
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.lightsail.model.ResourceRecord) extends ResourceRecord.ReadOnly {
    override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
    override def typeValue: scala.Option[String] = scala.Option(impl.`type`()).map(value => value: String)
    override def valueValue: scala.Option[String] = scala.Option(impl.value()).map(value => value: String)
  }
  def wrap(impl: software.amazon.awssdk.services.lightsail.model.ResourceRecord): ReadOnly = new Wrapper(impl)
}